<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCoreUserTable extends Migration
{
    protected $tableName = 'core_user';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create($this->tableName, function (Blueprint $table) {
            $table->increments('user_id');
            $table->string('username')->unique();
            $table->string('email')->unique();
            $table->string('first')->default(null);
            $table->string('last')->default(null);
            $table->string('password')->default(null)->collate('utf8_bin');
            $table->string('password_salt')->nullable()->default(null)->collate('utf8_bin');
            $table->unsignedTinyInteger('status');
            $table->boolean('internal');
            $table->rememberToken();
            $table->timestamp('last_login_at');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists($this->tableName);
    }
}
