@php
$field = request('field', array_first(array_keys($filter['options'])));
$start = request()->get('startDate', null);
$end = request()->get('endDate', null);

@endphp
<div class="col-sm-12 form-group report-filter-date">
    <label for="daterange"><span class="fa fa-calendar"></span> Filter by date</label>
    <select id="date_filter_field" name="field" class="form-control select2">
        @foreach ($filter['options'] as $value => $label)
        <option value="{{ $value }}" {{ $field === $value ? 'selected' : '' }}>{{ $label }}</option>
        @endforeach
    </select>
    <input id="daterange" class="form-control report-filter-daterangepicker" type="text" name="range" value="{{ $start && $end ? $start . ' - ' . $end : '' }}" />
</div>

@section('css')
    <style>
        .report-filter-date .select2 {
            display: inline-block;
            margin-left: 10px;
            width: 175px !important;
        }
        .report-filter-daterangepicker {
            display: inline-block;
            margin-left: 10px;
            position: relative;
            top: 0;
            width: 175px;
        }
    </style>
    @parent
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script type="text/javascript">
      $(document).ready(function() {
        $('#daterange').daterangepicker({
          ranges: {
            'Last 7 Days': [moment().subtract(7, 'days'), moment()],
            'Last 30 Days': [moment().subtract(30, 'days'), moment()],
            'Last 60 Days': [moment().subtract(60, 'days'), moment()],
            'WTD': [moment().startOf('week'), moment()],
            'MTD': [moment().startOf('month'), moment()],
            'QTD': [moment().startOf('quarter'), moment()],
            'YTD': [moment().startOf('year'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'This Quarter': [moment().startOf('quarter'), moment().endOf('quarter')],
            'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
            'This Year': [moment().startOf('year'), moment().endOf('year')]
          },
          autoUpdateInput: false,
          opens: 'center',
          drops: 'down',
          alwaysShowCalendars: true,
        }, function(start, end, label) {
          if (start !== 'Invalid date' && end !== 'Invalid date') {
            $('#daterange').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
            window.location.href = '{{ route('admin.reports.show', $report) }}/?field=' + $('#date_filter_field').val() + '&startDate=' + start.format('YYYY-MM-DD') + '&endDate=' + end.format('YYYY-MM-DD');
          }
        });
      });
    </script>
@endsection
