<?php

Route::group([
    'prefix' => '/admin',
    'namespace' => 'Admin',
    'middleware' => ['guest']
], function () {
    Route::get('/login', 'SessionController@create')->name('admin.session.create');
    Route::post('/login', 'SessionController@store')->name('admin.session.store');
});

// Admin Pages Routes
Route::group([
    'prefix' => '/admin',
    'namespace' => 'Admin',
    'middleware' => ['web', 'auth'],
], function () {
    Route::any('/logout', 'SessionController@destroy')->name('admin.session.destroy');

    // Dashboard
    Route::get('/', 'AdminController@index')->name('admin.dashboard.index')->middleware('can:core.dashboard.browse');
    Route::get('/index', 'AdminController@index')->middleware('can:core.dashboard.browse');

    // Impersonation Routes
    Route::get('/mask/{userId}', 'AdminController@mask')->name('admin.mask')->middleware('can:core.user.impersonate');
    Route::get('/unmask', 'AdminController@unmask')->name('admin.unmask');

    // Security Admin Routes
    Route::group(['prefix' => '/security'], function () {
        // Users
        Route::any('/users', 'UsersController@index')->name('admin.security.users.index')->middleware('can:core.security.users.browse');
        Route::get('/users/{user}/edit', 'UsersController@edit')->name('admin.security.users.edit')->middleware('can:core.security.users.update');
        Route::patch('/users/{user}', 'UsersController@update')->name('admin.security.users.update')->middleware('can:core.security.users.update');
        Route::get('/users/{user}/activate', 'UsersController@activate')->name('admin.security.users.activate')->middleware('can:core.security.users.activate');
        Route::get('/users/{user}/deactivate', 'UsersController@deactivate')->name('admin.security.users.deactivate')->middleware('can:core.security.users.deactivate');

        // Groups
        Route::any('/groups', 'GroupsController@index')->name('admin.security.groups.index')->middleware('can:core.security.groups.browse');
        Route::get('/groups/create', 'GroupsController@create')->name('admin.security.groups.create')->middleware('can:core.security.groups.create');
        Route::post('/groups/create', 'GroupsController@store')->name('admin.security.groups.store')->middleware('can:core.security.groups.create');
        Route::get('/groups/{group}/edit', 'GroupsController@edit')->name('admin.security.groups.edit')->middleware('can:core.security.groups.update');
        Route::patch('/groups/{group}', 'GroupsController@update')->name('admin.security.groups.update')->middleware('can:core.security.groups.update');
        Route::delete('/groups/delete', 'GroupsController@destroyMany')->name('admin.security.groups.destroyMany')->middleware('can:core.security.groups.delete-many');
        Route::delete('/groups/{group}', 'GroupsController@destroy')->name('admin.security.groups.destroy')->middleware('can:core.security.groups.delete');

        // Permissions
        Route::any('/permissions', 'PermissionsController@index')->name('admin.security.permissions.index')->middleware('can:core.security.permissions.browse');
        Route::get('/permissions/create', 'PermissionsController@create')->name('admin.security.permissions.create')->middleware('can:core.security.permissions.create');
        Route::post('/permissions/create', 'PermissionsController@store')->name('admin.security.permissions.store')->middleware('can:core.security.permissions.create');
        Route::get('/permissions/{permission}/edit', 'PermissionsController@edit')->name('admin.security.permissions.edit')->middleware('can:core.security.permissions.update');
        Route::patch('/permissions/{permission}', 'PermissionsController@update')->name('admin.security.permissions.update')->middleware('can:core.security.permissions.update');
        Route::delete('/permissions/delete', 'PermissionsController@destroyMany')->name('admin.security.permissions.destroyMany')->middleware('can:core.security.permissions.delete-many');
        Route::delete('/permissions/{permission}', 'PermissionsController@destroy')->name('admin.security.permissions.destroy')->middleware('can:core.security.permissions.delete');
    });

    // Admin Participant Pages Routes
    Route::group(['prefix' => '/participant'], function () {
        // Internal Users
        Route::any('/internal/{status?}', 'InternalController@index')->name('admin.participant.internal')->middleware('can:core.user.internal.browse');
        Route::any('/internal/{status?}/export', 'InternalController@index')->name('admin.participant.internal.export')->middleware('can:core.user.internal.browse');

        // Trashed Users
        Route::any('/trashed', 'TrashedController@index')->name('admin.participant.trashed')->middleware('can:core.user.trashed.browse');
        Route::any('/trashed/export', 'TrashedController@index')->name('admin.participant.trashed.export')->middleware('can:core.user.trashed.browse');
        Route::put('/trashed/restore', 'TrashedController@store')->name('admin.participant.restore')->middleware('can:core.user.trashed.restore');
        Route::delete('/trashed/shred', 'TrashedController@destroy')->name('admin.participant.shred')->middleware('can:core.user.trashed.shred');

        // Participant Users
        Route::any('/participants', 'ParticipantController@index')->name('admin.participant.index')->middleware('can:core.user.participant.browse');
        Route::any('/participants/export', 'ParticipantController@index')->name('admin.participant.index.export')->middleware('can:core.user.participant.browse');
        Route::get('/participants/show/{userId}', 'ParticipantController@show')->name('admin.participant.show')->middleware('can:core.user.participant.browse');
        Route::get('/participants/create', 'ParticipantController@create')->name('admin.participant.create')->middleware('can:core.user.participant.create');
        Route::post('/participants/store', 'ParticipantController@store')->name('admin.participant.store')->middleware('can:core.user.participant.create');
        Route::get('/participants/edit/{userId}', 'ParticipantController@edit')->name('admin.participant.edit')->middleware('can:core.user.participant.update');
        Route::post('/participants/update/{id}', 'ParticipantController@update')->name('admin.participant.update')->middleware('can:core.user.participant.update');
        Route::get('/participants/delete/{id}', 'ParticipantController@delete')->name('admin.participant.delete')->middleware('can:core.user.participant.delete');
        Route::delete('/participants/destroy/{id}', 'ParticipantController@destroy')->name('admin.participant.destroy')->middleware('can:core.user.participant.delete');

        // Tables/Lists
        Route::any('/participants/{participant}/transactions', 'ParticipantTransactionsController@index')->name('admin.participant.transactions')->middleware('can:core.user.transaction.browse');
        Route::post('/participants/{participant}/transactions/store', 'ParticipantTransactionsController@store')->name('admin.participant.transactions.store')->middleware('can:core.user.transaction.create');
        Route::any('/participants/{participant}/history', 'ParticipantHistoryController@index')->name('admin.participant.history')->middleware('can:core.user.history.browse');
        Route::any('/participants/{participant}/activity', 'ParticipantActivityController@index')->name('admin.participant.activity')->middleware('can:core.user.activity.browse');
        Route::any('/participants/{participant}/notes', 'ParticipantNotesController@index')->name('admin.participant.notes')->middleware('can:core.user.notes.browse');
        Route::post('/participants/{participant}/notes/create', 'ParticipantNotesController@store')->name('admin.participant.note.create')->middleware('can:core.user.notes.create');
    });

    // Import Admin Routes
    Route::group(['prefix' => '/import'], function () {
        Route::get('/', 'ImportController@index')->name('admin.import.index')->middleware('can:core.import.browse');
        Route::post('/store', 'ImportController@store')->name('admin.import.store')->middleware('can:core.import.create');
        Route::get('/{id}', 'ImportController@show')->name('admin.import.show')->middleware('can:core.import.view');
        Route::delete('/{id}', 'ImportController@destroy')->name('admin.import.destroy')->middleware('can:core.import.delete');
        // Routes that interact with the import file.
        Route::post('/run/{id}', 'RunController@store')->name('admin.import.run')->middleware('can:core.import.run');
        Route::get('/preview/{id}/{offset?}', 'RunController@preview')->name('admin.import.preview')->middleware('can:core.import.preview');
        Route::get('/download/{id}', 'RunController@download')->name('admin.import.download')->middleware('can:core.import.download');
        Route::get('/generate/{id}', 'RunController@generate')->name('admin.import.generate')->middleware('can:core.import.generate');
    });

    // Report Admin Routes
    Route::group(['prefix' => '/reports'], function () {
        Route::any('/', 'ReportController@index')->name('admin.reports.index')->middleware('can:core.report.browse');
        Route::any('/show/{id}', 'ReportController@show')->name('admin.reports.show')->middleware('can:core.report.browse');
        Route::any('/show/{id}/export', 'ReportController@show')->name('admin.reports.export')->middleware('can:core.report.export');
        Route::get('/send/{id}', 'ReportController@send')->name('admin.reports.send')->middleware('can:core.report.send');
    });

    // Blocks Admin Routes
    Route::group(['prefix' => '/cms/blocks'], function () {
        Route::any('/', 'BlockController@index')->name('admin.blocks.index')->middleware('can:core.cms.blocks.browse');
        Route::any('/export', 'BlockController@index')->name('admin.blocks.index.export')->middleware('can:core.cms.blocks.browse');
        Route::get('create', 'BlockController@create')->name('admin.blocks.create')->middleware('can:core.cms.blocks.create');
        Route::post('store', 'BlockController@store')->name('admin.blocks.store')->middleware('can:core.cms.blocks.create');
        Route::get('edit/{id}', 'BlockController@edit')->name('admin.blocks.edit')->middleware('can:core.cms.blocks.update');
        Route::put('update/{id}', 'BlockController@update')->name('admin.blocks.update')->middleware('can:core.cms.blocks.update');
        Route::delete('delete/{id}', 'BlockController@destroy')->name('admin.blocks.destroy')->middleware('can:core.cms.blocks.delete');
        Route::delete('delete-many', 'BlockController@destroyMany')->name('admin.blocks.destroyMany')->middleware('can:core.cms.blocks.delete.many');
    });

    // Pages Admin Routes
    Route::group(['prefix' => '/cms/pages'], function () {
        Route::get('/', 'PageController@index')->name('admin.pages.index')->middleware('can:core.cms.pages.browse');
        Route::get('create', 'PageController@create')->name('admin.pages.create')->middleware('can:core.cms.pages.create');
        Route::post('store', 'PageController@store')->name('admin.pages.store')->middleware('can:core.cms.pages.create');
        Route::get('edit/{id}', 'PageController@edit')->name('admin.pages.edit')->middleware('can:core.cms.pages.update');
        Route::put('update/{id}', 'PageController@update')->name('admin.pages.update')->middleware('can:core.cms.pages.update');
    });
});

// Blocks Routes: Api
Route::group(
    [
        'middleware' => ['web', 'auth'],
        'namespace'  => 'Api',
        'prefix'     => '/admin/cms/blocks/api'
    ],
    function () {
        Route::get('/', 'BlockController@index')->name('api.blocks.index')->middleware('can:core.cms.blocks.browse');
    }
);

// Pages Api Routes
Route::group(
    [
        'middleware' => ['web', 'auth'],
        'namespace'  => 'Api',
        'prefix'     => '/admin/cms/pages/api'
    ],
    function () {
        Route::post('reorder', 'PageController@reorder')->name('admin.pages.reorder')->middleware('can:core.cms.pages.reorder');
        Route::post('toggle/{id}', 'PageController@toggle')->name('admin.pages.toggle')->middleware('can:core.cms.pages.status-toggle');
        Route::post('templates', 'PageController@templates')->name('admin.pages.api.templates')->middleware('can:core.cms.pages.templates');
        Route::post('upload', 'PageController@upload')->name('admin.pages.api.upload')->middleware('can:core.cms.pages.upload');
    }
);

// Core Controller Authenticated Routes
Route::group([
    'middleware' => ['web', 'auth']
], function () {

    // Logout Routes
    Route::get('logout', 'Auth\LoginController@logout')->name('logout');
    Route::post('logout', 'Auth\LoginController@logout')->name('logout');

    // Transaction Routes
    Route::group(['prefix' => '/transactions'], function () {
        Route::get('/', 'TransactionController@index')->name('participant.transaction.index');
    });

    // Participant Routes
    Route::group(['prefix' => '/participant'], function () {
        // Password
        Route::get('/password', 'PasswordController@edit')->name('participant.password.edit');
        Route::post('/password', 'PasswordController@update')->name('participant.password.update');

        // Profile
        Route::get('/profile', 'ProfileController@show')->name('participant.profile.show');
        Route::get('/edit', 'ProfileController@edit')->name('participant.profile.edit');
        Route::post('/edit', 'ProfileController@update')->name('participant.profile.update');
    });
});

// Core Controller Non-Authenticated Routes
Route::group([
    'middleware' => ['web', 'guest']
], function () {
    // Login Routes
    Route::get('login', 'Auth\LoginController@showLoginForm')->name('login');
    Route::post('login', 'Auth\LoginController@login');

    Route::get('login/{driver}', 'Auth\LoginController@redirectToProvider')->name('sso.redirect');
    Route::get('login/{driver}/callback', 'Auth\LoginController@handleProviderCallback')->name('sso.callback');

    // Unauthenticated Participant Pages Routes
    Route::get('enroll', 'EnrollmentController@create')->name('participant.enroll.create');
    Route::post('enroll', 'EnrollmentController@store')->name('participant.enroll.store');
    Route::get('enroll/accepted', 'EnrollmentAcceptedController@show')->name('participant.enroll.accepted');

    // Password Reset Routes...
    Route::get('password/reset', 'Auth\ForgotPasswordController@showLinkRequestForm')->name('password.request');
    Route::post('password/email', 'Auth\ForgotPasswordController@sendResetLinkEmail')->name('password.email');
    Route::get('password/reset/{token}', 'Auth\ResetPasswordController@showResetForm')->name('password.reset');
    Route::post('password/reset', 'Auth\ResetPasswordController@reset');
});

Route::group([
    'middleware' => ['web']
], function () {
    // Page Routes
    Route::redirect('/home', '/', 301);
    Route::get('/', 'PageController@index')->name('homepage');
    Route::get('{code}', 'PageController@show')->where('code', '.+')->name('page')->fallback();
});
