<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\User;
use Ignite\Core\Entities\Participant;

class ParticipantTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/core_participant.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                if ($source['email'] === 'it@brightspot.email') {
                    $source['email'] = config('core.admin.email', 'it@brightspot.email');
                }
                $user = User::where('email', $source['email'])->firstOrFail();
                $source['user_id'] = $user->getKey();
                $source['email'] = $user->email;
                $source['approved_at'] = date('Y-m-d H:i:s');
                $participant = new Participant();
                $participant->forceFill($source);
                $participant->save();
            } catch (\Exception $e) {
                echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
