<section class="chart-table {{ $size }}">
    <div class="box box-primary">
        <div class="box-header with-border">
            <h3 class="box-title">{{ $label }}</h3>
        </div>
        <div class="box-body">
            @if (isset($data) && $data->isNotEmpty())
                <ul class="products-list product-list-in-box">
                    @forelse ($data as $item)
                        <li class="item">
                            @if ($item->image)
                                @foreach (['s3', 'ignite3'] as $disk)
                                    @if (Storage::disk($disk)->has($item->image))
                                    <div class="product-img">
                                        <img src="{{ Storage::disk($disk)->url($item->image) }}" style="width: 60px; height: 40px;" width="60" alt="{{ $item->name }}">
                                    </div>
                                    @break
                                    @endif
                                @endforeach
                            @endif
                            <div class="product-info" style="margin-left: 70px">
                                <a href="javascript:void(0)" class="product-title">{{ $item->name }}
                                    <span class="label label-warning pull-right">{{ $item->total }}</span>
                                </a>
                            </div>
                        </li>
                    @empty
                    @endforelse
                </ul>
            @else
                <div class="text-muted text-center">
                    <span class="fa fa-exclamation-triangle fa-3x"></span>
                    <h3>No data available</h3>
                    <p>Try choosing a different date range</p>
                </div>
            @endif
        </div>
        {{ $slot }}
    </div>
</section>
