<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Claim\Entities\Offer;

class OfferSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'offer';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $offers = $this->parser->parse($this->path());

        foreach ($offers as $offer) {
            $this->seedOffer($offer);
        }
    }

    /**
     * Seed a table record.
     *
     * @param  array $offer
     * @return Offer
     */
    private function seedOffer($offer)
    {
        return Offer::updateOrCreate(['sku' => $offer['sku']], $offer);
    }
}
