<?php

namespace Ignite\Core\Http\Controllers\Api;

use Exception;
use Illuminate\Http\Request;
use Ignite\Core\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Ignite\Core\Contracts\Repositories\PageRepository;

class PageController extends Controller
{
    /** @var PageRepository */
    protected $pageRepository;

    /**
     * Create a new controller instance.
     *
     * @param PageRepository $pageRepository
     */
    public function __construct(PageRepository $pageRepository)
    {
        $this->pageRepository = $pageRepository;
    }

    /**
     * Reorder page positions.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function reorder()
    {
        try {
            $this->pageRepository->reorder(request()->json()->all());
            $status = 'success';
            $message = sprintf('Updated page positions successfully.');
        } catch (Exception $e) {
            $status = 'error';
            $message = $e->getMessage();
        }

        return response()->json([
            'status' => $status,
            'message' => $message,
        ]);
    }

    /**
     * Toggle an attribute.
     *
     * @param $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function toggle($id)
    {
        usleep(800);
        try {
            $name = request()->json('name');
            $value = request()->json('value');
            $value = $this->pageRepository->toggle($id, $name, $value);
            return response()->json([
                'status' => 'success',
                'message' => sprintf('`%s` attribute updated successfully.', $name),
                'value' => $value
            ]);
        } catch (Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage(),
                'value' => null
            ]);
        }
    }

    /**
     * Get the content templates based on the request code.
     *
     * @param  Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function templates(Request $request)
    {
        if ($request->has('code')) {
            $key = sprintf('core.cms.content.templates.%s.', $request->get('code'));
        } else {
            $key = 'core.cms.content.templates.';
        }

        $templates = config($key . '*', []);

        foreach ($templates as $path => $copy) {
            $templates[$path] = [
                'name' => Str::title(str_replace('.', ' ', str_replace($key, '', $path))),
                'copy' => $copy,
            ];
        }

        return response()->json($templates);
    }

    /**
     * Upload a file.
     *
     * @return \Illuminate\Contracts\Routing\UrlGenerator|string
     */
    public function upload()
    {
        $file = request()->file('myfile');
        $filename = $file->getClientOriginalName();
        $folder = 'uploads';
        $disk = config('Cms.disk');

        $file = $file->storeAs($folder, $filename, [
            'disk' => $disk,
            'visibility' => 'public'
        ]);

        return Storage::disk($disk)->url($folder. '/' . $filename);
    }
}
