<?php

namespace Ignite\Core\Helpers;

class Currency extends Amount
{
    /**
     * @var string
     */
    protected $currency;

    /**
     * Currency constructor.
     *
     * @param $value
     * @param string $currency
     */
    public function __construct($value, $currency = '$')
    {
        parent::__construct($value);
        $this->currency = $currency;
    }

    /**
     * Get the value formatted.
     *
     * @param int $decimals
     * @param int $default
     * @param int $rounding
     * @return string
     */
    public function format($decimals = 0, $default = 0, $rounding = null)
    {
        $value = parent::format($decimals, $default, $rounding);

        $value = money_format('%.2n', (float) str_replace([',', ' '], '', $value));

        return stripos($value, $this->currency) === false ? $this->currency . $value : $value;
    }
}
