<?php

namespace Ignite\Core\Events;

use Illuminate\Queue\SerializesModels;
use Ignite\Core\Entities\User;

class EnrollmentComplete
{
    use SerializesModels;

    /**
     * @var User
     */
    public $user;

    /**
     * Create a new event instance.
     *
     * @param User $user
     */
    public function __construct(User $user)
    {
        $this->user = $user;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
