<?php

namespace Ignite\Core\Database\Seeders;

use Ignite\Core\Entities\Group;

class GroupsTableSeeder extends AbstractSeeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        parent::run();

        /* TODO: Create a repository class for Groups
        $groupRepository = app(GroupRepository::class); */
        $strategy = $this->strategy('json', [
            'filepath' => realpath(__DIR__ . '/../Data/core_group.json')
        ]);

        /** @var \Illuminate\Support\Collection $sources */
        $sources = $strategy->run();

        foreach ($sources as $source) {
            try {
                Group::create($source);
            } catch (\Exception $e) {
                //echo $e->getMessage() . PHP_EOL;
                continue;
            }
        }
    }
}
