@extends('Core::layouts.page')

@section('title')@if (config('app.env') !== 'production'){{ config('app.env') === 'staging' ? 'BETA' : 'DEV' }} |@endif @yield('meta_title') | {{ config('app.name') }}@endsection

@section('body_class')
    @parent
    {{ 'env-' . config('app.env') }}
@endsection

@section('content_header')
	@if (isset($adminHeader))
		<h1>{{ $adminHeader }}</h1>
	@else
		@yield('heading')
	@endif

	<ol class="breadcrumb">
		<li><a href="{{ url('/admin') }}"><i class="fa fa-dashboard"></i> Home</a></li>
		@yield('breadcrumb')
	</ol>
	@yield('head')
	@yield('style')
@stop

@section('content')
	@include('Core::partials.alert')
	@include('ignite-flash::message')
	@yield('page_content')
@stop

@section('css')
	@parent
	<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css" />
    <link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/css/bootstrap-datetimepicker.min.css" />
    <link rel="stylesheet" href="{{ asset('/vendor/ignite/css/ignite.css') }}" />
    <link rel="stylesheet" href="{{ asset('/vendor/ignite/css/core/datatables.css') }}" />
@endsection

@section('js')
	@parent
	<script type="text/javascript" src="//code.jquery.com/ui/1.12.1/jquery-ui.js" integrity="sha256-T0Vest3yCU7pafRw9r+settMBX6JkKN06dqBnpQ8d30=" crossorigin="anonymous"></script>
	<script type="text/javascript" src="//cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.js"></script>
    <script type="text/javascript" src="{{ asset('/vendor/ignite/js/vendor/multiselect/multiselect.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/vendor/ignite/js/vendor/moment/moment.min.js') }}"></script>
    <script src="//cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.47/js/bootstrap-datetimepicker.min.js"></script>
	<script type="text/javascript" src="{{ asset('/vendor/ignite/js/ignite.js') }}"></script>
	<script type="text/javascript" src="{{ asset('/vendor/ignite/js/admin.js') }}"></script>
    <script type="text/javascript" src="{{ asset('/vendor/ignite/js/core/datatables.js') }}"></script>
@stop
