<?php

namespace Ignite\Core\Models\Grid;

class NoteFormatter extends Formatter
{
    /**
     * Format the full name of the user that added the note.
     *
     * @param  object $model
     * @return string
     */
    public function addedBy($model)
    {
        return $model->addedBy->first . ' ' . $model->addedBy->last;
    }

    /**
     * Format the note message.
     *
     * @param  object $model
     * @return string
     */
    public function message($model)
    {
        return str_limit($model->message, 100);
    }
}
