@extends('Core::layouts.main')

@section('meta_title', 'Permissions Security Management')
@section('page_heading', 'Permissions')
@section('page_breadcrumb', 'Permissions')

@section('breadcrumb')
    @parent
    <li><a href="#">Security</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.security.permissions.index') }}">Permissions Management</a></small>
    </h1>
@endsection

@section('page_content')
    <div class="row">
        <div class="col-sm-6">
            {!! form_start($form) !!}
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Edit Permission</h3>
                    </div>
                    <div class="box-body bg-gray-light">
                        {!! form_until($form, 'status') !!}
                    </div>
                    <div class="box-footer">
                        <div class="form-buttons clearfix">
                            {!! form_row($form->submit) !!}
                        </div>
                    </div>
                </div>
            {!! form_end($form) !!}
        </div>
        <div class="col-sm-6">
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title">Associations</h3>
                </div>
                <div class="box-body bg-gray-light">
                    @if ($permission->groups->count() > 0)
                        <p><strong>{{ $permission->key }}</strong> permission is associated with <strong>{{ $groupCount = $permission->groups->count() }}</strong> user {{ str_plural('group', $groupCount) }}.</p>
                        <ul>
                        @foreach ($permission->groups as $group)
                            <li><a href="{{ route('admin.security.groups.edit', $group->id) }}">{{ $group->name }}</a></li>
                        @endforeach
                        </ul>
                    @else
                        <p><strong>{{ $permission->key }}</strong> permission is not associated with any user groups.</p>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
