<?php

namespace Ignite\Core\Events;

use Illuminate\Queue\SerializesModels;
use Ignite\Core\Entities\Participant;

class EnrollmentDeleting
{
    use SerializesModels;

    /**
     * @var Participant
     */
    public $participant;

    /**
     * Create a new event instance.
     *
     * @param Participant $participant
     */
    public function __construct(Participant $participant)
    {
        $this->participant = $participant;
    }

    /**
     * The participant being deleted.
     *
     * @return Participant
     */
    public function getParticipant()
    {
        return $this->participant;
    }

    /**
     * Get the channels the event should be broadcast on.
     *
     * @return array
     */
    public function broadcastOn()
    {
        return [];
    }
}
