<?php

namespace Ignite\Core\Http\Controllers;

use Ignite\Core\Repositories\TransactionRepository;

class TransactionController extends Controller
{
    /** @var TransactionRepository */
    protected $transactionRepository;

    /**
     * Create a new controller instance.
     *
     * @param TransactionRepository $transactionRepository
     */
    public function __construct(TransactionRepository $transactionRepository)
    {
        $this->transactionRepository = $transactionRepository;
    }

    /**
     * Show the Transactions for the given participant.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        $transactions = $this->transactionRepository->findAuthenticated();

        return view('transaction.index', compact('transactions'));
    }
}
