<section class="chart-donut {{ $size }}">
    <div class="box box-primary" style="position: relative; overflow: hidden; height: 400px;">
        <div class="box-header">
            <i class="{{ $icon }}"></i>
            <h3 class="box-title">{{ $label }}</h3>
        </div>
        <div class="box-body border-radius-none">
            @if (empty($data))
                <div class="text-muted text-center">
                    <span class="fa fa-exclamation-triangle fa-3x"></span>
                    <h3>No data available</h3>
                    <p>Try choosing a different date range</p>
                </div>
            @else
            <div id="{{ $element }}" style="width: 100%; height: 300px;"></div>
            @endif
        </div>
        {{ $slot }}
    </div>
</section>
@section('js')
    @parent
    <script type="text/javascript">
    new Morris.Donut({
        element: '{{ $element }}',
        colors: {!! json_encode($colors) !!},
        resize: true,
        data: {!! json_encode($data ?? []) !!}
    });
    </script>
@endsection
