<?php

namespace Ignite\Import\Tests\Unit\Repositories;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Ignite\Core\Entities\Import;
use Ignite\Core\Repositories\ImportRepository;
use Ignite\Core\Tests\TestCase;
use Ignite\Core\Services\Importers\Transactions;

class ImportRepositoryTest extends TestCase
{
    use RefreshDatabase;

    /** @var ImportRepository */
    protected $repo;

    /**
     * Set up the test.
     *
     * @return void
     */
    public function setUp()
    {
        parent::setUp();

        $this->repo = new ImportRepository();
    }

    /**
     * @test
     * @group Import
     * @expectedException \DomainException
     */
    public function it_will_not_allow_creation_if_it_doesnt_know_its_type()
    {
        $this->repo->create([]);
    }

    /**
     * @test
     * @group Import
     */
    public function it_will_default_to_the_IT_user_when_it_cannot_determine_the_current_user()
    {
        $services = Transactions::class;

        $this->app['config']->set('core.import.types.transaction', [
            'label' => 'Transaction',
            'class' => $services
        ]);

        $import = $this->repo->create([
            'type' => $services,
            'file' => 'demo.csv'
        ]);

        $this->assertSame(1, $import->created_by);
    }
}