<?php

namespace Ignite\Core\Audit;

use Ignite\Core\Entities\User;
use Ignite\Core\Entities\Participant;
use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\AuditDriver;
use OwenIt\Auditing\Drivers\Database;
use OwenIt\Auditing\Models\Audit;

class ParticipantDriver extends Database implements AuditDriver
{
    /**
     * Perform an audit.
     *
     * @param \OwenIt\Auditing\Contracts\Auditable $model
     *
     * @return Audit
     */
    public function audit(Auditable $model)
    {
        $class = config('audit.implementation', Audit::class);
        $audit = $model->toAudit();
        $audit['context_type'] = Participant::class;
        $audit['context_id']   = $this->getContextId($model);

        return $class::create($audit);
    }

    /**
     * Determine the context id based on model type.
     *
     * @param  Auditable $model
     * @return mixed
     */
    private function getContextId(Auditable $model)
    {
        if ($model instanceof User || $model instanceof Participant) {
            return $model->getKey();
        }

        return null;
    }
}