@extends('Core::layouts.participant')

@section('page_heading', $pageTitle = 'Trashed Users')
@section('page_breadcrumb', $pageTitle)

@section('page_content')
    <div class="box box-primary">
        <div class="box-body">
            {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
            <form id="participant-restore-form" action="{{ route('admin.participant.restore') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('PUT') }}
                <input type="hidden" name="ids" value="" id="participant-restore-field" />
            </form>
            <form id="participant-shred-form" action="{{ route('admin.participant.shred') }}" method="post">
                {{ csrf_field() }}
                {{ method_field('DELETE') }}
                <input type="hidden" name="ids" value="" id="participant-shred-field" />
            </form>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <!--script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script-->
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    enabled: false,
                    text: '<span class="fa fa-recycle text-success"></span> <span class="text-success">Restore</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = 'You are about to restore ' + selected.length + ' record(s). Are you sure you wish to proceed?';
                        if (confirm(message)) {
                            $('#participant-restore-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#participant-restore-form').submit();
                        }
                    }
                }, {
                    enabled: false,
                    text: '<span class="fa fa-times text-danger"></span> <span class="text-danger">Permanently Delete</span>',
                    action: function (e, dt, node, conf) {
                        var selected = dt.column(0).checkboxes.selected();
                        var message = 'You are about to permanently delete ' + selected.length + ' record(s). Are you sure you wish to proceed?';
                        if (confirm(message)) {
                            $('#participant-shred-field').val(selected.map(function(box) { return $(box).val(); }).join(','));
                            $('#participant-shred-form').submit();
                        }
                    }
                }]
            });
        });
    </script>
@endsection
