<?php

namespace Ignite\Core\Http\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Kris\LaravelFormBuilder\FormBuilderTrait;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests, FormBuilderTrait;

    /**
     * Log the exception.
     *
     * @param \Exception $exception
     */
    protected function logException(\Exception $exception)
    {
        logger()->error($exception->getMessage(), [
            'file' => $exception->getFile(),
            'code' => $exception->getCode(),
            'line' => $exception->getLine(),
            'class' => get_class($exception),
            'trace' => $exception->getTraceAsString()
        ]);
    }

    /**
     * Get the registration page content from the database.
     *
     * @param  string $key
     * @return \Ignite\Core\Entities\Page
     */
    protected function getPageContent($key)
    {
        $pageRepository = app(\Ignite\Core\Contracts\Repositories\PageRepository::class);
        $page = $pageRepository->findByCode($key);

        if (! $page) {
            $page = app(\Ignite\Core\Entities\Page::class);
        }

        return $page;
    }

    /**
     * Flash a translated success message to the session.
     *
     * @param  string  $message
     * @param  array  $data
     * @return \Laracasts\Flash\FlashNotifier
     */
    protected function flashSuccess($message, $data = [])
    {
        return $this->flashMessage('success', $message, $data);
    }

    /**
     * Flash a translated error message to the session.
     *
     * @param  string  $message
     * @param  array  $data
     * @return \Laracasts\Flash\FlashNotifier
     */
    protected function flashError($message, $data = [])
    {
        return $this->flashMessage('error', $message, $data);
    }

    /**
     * Flash a translated warning message to the session.
     *
     * @param  string  $message
     * @param  array  $data
     * @return \Laracasts\Flash\FlashNotifier
     */
    protected function flashWarning($message, $data = [])
    {
        return $this->flashMessage('warning', $message, $data);
    }

    /**
     * Flash a translated info message to the session.
     *
     * @param  string  $message
     * @param  array  $data
     * @return \Laracasts\Flash\FlashNotifier
     */
    protected function flashInfo($message, $data = [])
    {
        return $this->flashMessage('info', $message, $data);
    }

    /**
     * Flash a translated message to the session.
     *
     * @param  string  $type
     * @param  string  $message
     * @param  array  $data
     * @return \Laracasts\Flash\FlashNotifier
     */
    protected function flashMessage($type, $message, $data = [])
    {
        return $this->flash($type, trans($message, $data));
    }

    /**
     * Flash a message to the session.
     *
     * @param  string  $type
     * @param  string  $message
     * @return \Laracasts\Flash\FlashNotifier
     */
    protected function flash($type, $message)
    {
        return flash()->message($message, $type)->important();
    }
}
