<?php

namespace Ignite\Core\Models\Dashboard;

use Ignite\Core\Contracts\Dashboard\Donut as DonutInterface;

abstract class Donut extends Chart implements DonutInterface
{
    /**
     * The color of the stat.
     *
     * @return string
     */
    public function getColors()
    {
        return $this->get('colors');
    }

    /**
     * The HTML class of an icon.
     *
     * @return string
     */
    public function getIcon()
    {
        return $this->get('icon');
    }

    /**
     * The simple name of the type of stat.
     *
     * @return string
     */
    public function getType()
    {
        return 'donut';
    }
}
