<?php

namespace Ignite\Core\Models\Dashboard;

use Ignite\Core\Contracts\Dashboard\Stat as StatInterface;
use Ignite\Core\Facades\Format;

abstract class CorrelatedStat extends Stat implements StatInterface
{
    /**
     * The percentage of the total stat.
     *
     * @return string
     */
    public function getPercentage()
    {
        return $this->get('percentage');
    }

    /**
     * Calculate the percentage.
     *
     * @return int
     */
    protected function calculatePercentage()
    {
        $total = (float) $this->get('total', 1);
        $amount = (float) $this->get('data', 1);
        $total = ($total < 1) ? 1 : $total;

        return Format::amount(($amount / $total) * 100);
    }

    /**
     * The simple name of the type of stat.
     *
     * @return string
     */
    public function getType()
    {
        return 'correlated-stat';
    }
}
