<?php

namespace Ignite\Core\Http\ViewComposers;

use Ignite\Core\Contracts\Repositories\PageRepository;
use Ignite\Core\Models\Menu\UserNavigationMenu;
use Ignite\Core\Program;
use Illuminate\Support\HtmlString;
use Illuminate\View\View;

class UserNavigationMenuComposer extends NavigationMenuComposer
{
    public function __construct(PageRepository $pages, UserNavigationMenu $manager, Program $program)
    {
        parent::__construct($pages, $manager, $program);
    }

    /**
     * Bind data to the view.
     *
     * @param  View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $this->manager->merge(collect($this->getAuthenticatedItems()));

        $this->manager->remove('/unmask');
        $this->manager->remove('/logout');
        $this->manager->remove('/admin');

        $view->with('menu', new HtmlString($this->manager->render()));
    }
}
