@extends('Core::layouts.main')

@section('meta_title', 'Groups Security Management')
@section('page_heading', 'Groups')
@section('page_breadcrumb', 'Groups')

@section('breadcrumb')
    @parent
    <li><a href="#">Security</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.security.users.index') }}">Groups Management</a></small>
    </h1>
@endsection

@section('page_content')
    <div class="row">
        {!! form_start($form) !!}
            <div class="col-sm-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Edit Group</h3>
                    </div>
                    <div class="box-body bg-gray-light">
                        {!! form_until($form, 'status') !!}
                    </div>
                    <div class="box-footer">
                        <div class="form-buttons clearfix">
                            {!! form_row($form->submit) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">Assign Permissions</h3>
                        <div class="checkbox no-margin pull-right" style="padding-right: 11px;">
                            <label class="permissions-all-toggle">
                                <input type="checkbox" class="toggle-all">
                                <span class="toggle-label">Select All</span>
                            </label>
                        </div>
                    </div>
                    <div class="box-body bg-gray-light">
                        <div class="box-group" id="accordion">
                            @foreach ($permissions->groupByKeyPrefix() as $heading => $grouping)
                                @php $slug = str_slug($heading); @endphp
                            <div class="panel box no-border permission-group" data-id="{{ $slug }}">
                                <div class="box-header with-border">
                                    <h4 class="box-title pull-left">
                                        <a data-toggle="collapse" data-parent="#accordion" href="#{{ $slug }}">
                                            {{ ucwords(str_slug($heading, ' ')) }}
                                        </a>
                                        <span style="position: absolute; right: 110px;" class="label label-default bg-gray-light text-success" id="count-{{ $slug }}">0</span>
                                    </h4>
                                    <div class="checkbox no-margin pull-right">
                                        <label class="permissions-group-toggle">
                                            <input class="permissions-group-checkbox" data-toggle-group="{{ $slug }}" type="checkbox" value="toggle-{{ $slug }}">
                                            <span class="toggle-label">Select All</span>
                                        </label>
                                    </div>
                                </div>
                                <div id="{{ $slug }}" class="panel-collapse collapse {{-- $loop->index === 0 ? 'in' : '' --}}">
                                    <div class="box-body">
                                        <div class="row">
                                        @foreach ($grouping as $permission)
                                            <div class="col-md-6">
                                                <div class="checkbox">
                                                    <label>
                                                        <input class="permission-checkbox" {{ $group->hasPermission($permission->key) ? 'checked' : '' }} data-group="{{ $slug }}" type="checkbox" name="permissions[]" value="{{ $permission->id }}"> <strong>{{ $permission->key }}</strong>
                                                        <p class="help-block">{{ $permission->description }}</p>
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                        </div>
                    </div>
                </div>
            </div>
        {!! form_end($form) !!}
    </div>
@endsection

@section('js')
    @parent
    <script type="text/javascript" src="{{ asset('/vendor/ignite/js/core/permissions.js') }}"></script>
    <script type="text/javascript">
        jQuery(document).ready(function ($) {
            $('.permission-group').permissions();
        });
    </script>
@endsection