@extends('Core::layouts.main')

@section('meta_title', 'Participant Management')

@section('heading')
    <h1>
        @yield('page_heading')
        <small><a href="{{ route('admin.participant.index') }}">Participant Management</a></small>
    </h1>
@endsection

@section('breadcrumb')
    @parent
    <li><a href="{{ route('admin.participant.index') }}">Participant Management</a></li>
    <li class="active">@yield('page_breadcrumb')</li>
@endsection

@section('page_content')
    <div class="nav-tabs-custom">
        @yield('tab_menu')
        <div class="tab-content">
            @yield('tab_content')
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script>
        jQuery(document).ready(function($) {
            $('select').addClass('select2');
            $('.datepicker').datepicker({
                format: 'yyyy-mm-dd',
                autoclose: true
            }).on('show.bs.modal', function(event) {
                // Prevent datepicker from firing bootstrap modal "show.bs.modal"
                event.stopPropagation();
            });
          $('.datetimepicker').datetimepicker({
            format: 'MM/DD/YYYY HH:mm:ss',
            icons: {
              time: "fa fa-clock-o",
              date: "fa fa-calendar",
              up: "fa fa-arrow-up",
              down: "fa fa-arrow-down",
              previous: 'fa fa-chevron-left',
              next: 'fa fa-chevron-right',
              today: 'fa fa-calendar-times-o',
              clear: 'fa fa-trash',
              close: 'fa fa-remove'
            }
          });
        });
    </script>
@endsection
