<?php

namespace Ignite\Core\Helpers;

class Amount
{
    /**
     * @var int|float|string
     */
    protected $value;

    /**
     * Currency constructor.
     *
     * @param $value
     * @param string $currency
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * Get the value formatted.
     *
     * @param int $decimals
     * @param int $default
     * @param int $rounding
     * @return string
     */
    public function format($decimals = 0, $default = 0, $rounding = PHP_ROUND_HALF_UP)
    {
        if (is_null($this->value) || trim($this->value) === '') {
            $this->value = $default;
        }

        $amount = preg_replace('/[,$]/', '', $this->value);

        if (is_null($rounding)) {
            $amount = round($amount, $decimals, $rounding);
        }

        return number_format($amount, $decimals);
    }
}
