<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Models\Menu\ParticipantMenu;
use Ignite\Core\Program;

class ParticipantFormatter extends Formatter
{
    /**
     * @var Program
     */
    protected $program;

    /**
     * ParticipantFormatter constructor.
     *
     * @param Program $program
     */
    public function __construct(Program $program)
    {
        $this->program = $program;
    }

    /**
     * Custom column for actions.
     *
     * @param  \Ignite\Core\Entities\Participant $model
     * @return \Illuminate\Support\HtmlString
     */
    public function actions($model)
    {
        /** @var \Ignite\Core\Models\Menu\ActionMenu $manager */
        $manager = resolve(\Ignite\Core\Models\Menu\ActionMenu::class);
        $manager->merge(
            $manager->hydrateItems(
                collect([
                    [
                        'position' => 10,
                        'url' => route('admin.participant.show', $model->user_id),
                        'label' => 'View',
                        'icon' => 'eye-open',
                        'allow' => auth()->user()->can('core.user.participant.browse'),
                        'children' => [
                            [
                                'position' => 20,
                                'url' => route('admin.participant.edit', $model->user_id),
                                'label' => 'Edit',
                                'icon' => 'edit',
                                'allow' => auth()->user()->can('core.user.participant.update')
                            ], [
                                'position' => 50,
                                'url' => route('admin.participant.transactions', [$model->user_id]),
                                'label' => 'View Transactions',
                                'icon' => 'check-circle-o',
                                'allow' => auth()->user()->can('core.user.transaction.browse')
                            ], [
                                'position' => 60,
                                'url' => route('admin.participant.history', [$model->user_id]),
                                'label' => 'View History',
                                'icon' => 'history',
                                'allow' => auth()->user()->can('core.user.history.browse')
                            ], [
                                'position' => 70,
                                'url' => route('admin.participant.activity', [$model->user_id]),
                                'label' => 'View Activity',
                                'icon' => 'heartbeat',
                                'allow' => auth()->user()->can('core.user.activity.browse')
                            ], [
                                'position' => 80,
                                'url' => route('admin.participant.notes', [$model->user_id]),
                                'label' => 'View Notes',
                                'icon' => 'sticky-note',
                                'allow' => auth()->user()->can('core.user.activity.browse')
                            ], [
                                'position' => 90,
                                'url' => route('admin.mask', $model->user_id),
                                'label' => 'Masquerade',
                                'icon' => 'user-secret',
                                'allow' => auth()->user()->can('core.user.impersonate')
                            ]
                        ]
                    ],
                ])
            )
        );

        return $this->html($manager->render([
            'primaryKey' => $model->user_id,
            'model' => \Ignite\Core\Entities\Participant::class
        ]));
    }

    /**
     * Format the participant's full name.
     *
     * @param  object $model
     * @return string
     */
    public function name($model)
    {
        return $model->first . ' ' . $model->last;
    }

    /**
     * Format the agree confirm 1 as Yes or No.
     *
     * @param  object $model
     * @return string
     */
    public function agreeConfirm1($model)
    {
        return $this->formatYesNo($model->agree_confirm_1);
    }

    /**
     * Format agree confirm 2 as Yes or No.
     *
     * @param  object $model
     * @return string
     */
    public function agreeConfirm2($model)
    {
        return $this->formatYesNo($model->agree_confirm_2);
    }

    /**
     * Format internal as Yes or No.
     *
     * @param  object $model
     * @return string
     */
    public function internal($model)
    {
        return $this->formatYesNo($model->internal);
    }

    /**
     * Format archived as Yes or No.
     *
     * @param  object $model
     * @return string
     */
    public function archived($model)
    {
        return $this->formatYesNo($model->archived);
    }

    /**
     * Get a participant checkbox based on their ID.
     *
     * @param  object $model
     * @return \Illuminate\Support\HtmlString
     */
    public function checkbox($model)
    {
        return $this->formatCheckbox($model->user_id);
    }
}
