@extends('Core::layouts.cms')

@php
    $templateCode = str_replace('/', '.', $block->code);
@endphp

@section('page_heading', 'Create Block')
@section('page_breadcrumb', 'Create Block')

@section('page_content')
    @include('Core::admin.cms.partials.form.block', [
        'url' => route('admin.blocks.store'),
        'page' => $block,
        'method' => 'POST'
    ])
    @include('Core::admin.cms.partials.form.template-modal', compact('templateCode'))
@endsection

@section('js')
    @parent
    <script type="text/javascript">
        window.Blocks = {};
        window.Blocks.code = $('#form-content-code').val() || '';
        window.Blocks.indexUrl = "{{ route('admin.blocks.index') }}";
        window.Blocks.createUrl = "{{ route('admin.blocks.create') }}";
        window.Laravel = window.Laravel || {};
        window.Laravel.csrfToken = "{{ csrf_token() }}";

        jQuery(document).ready(function($) {
            $('#page-editor').igniteEditor({
                csrfToken: window.Laravel.csrfToken,
                templateCode: window.Blocks.code
            });
        });
    </script>
@endsection
