<?php

namespace Ignite\Core\Models\Seeds;

use Ignite\Report\Entities\Report;

class ReportSeeder extends BaseSeeder
{
    /** @var string */
    protected $json = 'report';

    /**
     * Seed the database table.
     *
     * @throws \Exception
     */
    public function seed()
    {
        $reports = $this->parser->parse($this->path());

        foreach ($reports as $report) {
            $this->seedReport($report);
        }
    }

    /**
     * Seed a table record.
     *
     * @param  array $report
     * @return Report
     */
    private function seedReport($report)
    {
        return Report::updateOrCreate(['name' => $report['name']], $report);
    }
}
