<?php

namespace Ignite\Core\Models\Grid;

class TrashedTable extends ParticipantTable
{
    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [
        'checkbox', 'user_id'
    ];

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        $columns = array_merge(
            ['checkbox' => $this->checkboxColumn()],
            parent::columns()
        );

        unset($columns['action']);

        return $columns;
    }

    /**
     * Add the checkbox field to the column map.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        $specials = parent::getColumnFormattingMap();

        $specials['checkbox'] = [$this->formatter, 'checkbox'];

        return $specials;
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        $params = parent::getBuilderParameters();

        return array_merge($params, [
            'buttons' => ['csv'],
            "order" => [2, 'asc'],
            'select' => [
                'info' => true,
                'style' => 'multi',
                'selector' => 'td:first-child'
            ],
            'columnDefs' => [
                ['targets' => 0, 'checkboxes' => ['selectRow' => true]]
            ],
        ]);
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())->keyBy('name')->except('action', 'checkbox')->keys()->toArray();

        return $this->applyScopes(
            $this->getConnection()->table('core_participant AS participant')
                 ->select($columns)
                 ->distinct()
                 ->leftJoin('core_user AS user', 'user.user_id', '=', 'participant.user_id')
                 ->whereNotNull('participant.deleted_at')
        );
    }
}
