<?php

namespace Ignite\Core\Models\Options;

use Ignite\Core\Contracts\Source;
use Ignite\Core\Entities\User;

class UserTypes implements Source
{
    /**
     * The source as a key-value pair array with the value as the key and the label as the value.
     *
     * @return array
     */
    public function toDropdown()
    {
        try {
            return User::getTypeList();
        } catch (\Exception $e) {
            logger()->error('Unable to retrieve user types for source model.', $e);
            return [];
        }
    }
}
