@extends('Core::layouts.participant')

@section('page_heading', $pageTitle = sprintf('#%s - %s', $participant->getId(), $name = $participant->getFullName()))
@section('page_breadcrumb', $pageTitle)

@section('page_content')
    <div class="form-horizontal">
        <div class="row form-affix-container">
            @include('Core::partials.menu')
            <div class="col-sm-9 form-affix-body">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h2 class="box-title">{{ $name }}'{{ ends_with($name, 's') ? '' : 's' }} Notes</h2>
                    </div>
                    <div class="box-body">
                        {!! $dataTable->table(['class' => 'table dt-table-border']) !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="note-add">
        <div class="modal-dialog">
            <form class="modal-content" id="form_participants_notes" method="post" action="{{ route('admin.participant.note.create', $participantId) }}">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <h4 class="modal-title">Create a note for {{ $name }}</h4>
                </div>
                <div class="modal-body">
                    {{ csrf_field() }}
                    <div class="form-group">
                        <label for="message">Note</label>
                        <textarea id="message" class="form-control" required name="message" rows="3" cols="100"></textarea>
                        <div class="help-block">
                            Please enter a useful not of at least 10 characters.
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('js')
    @parent
    <script src="https://cdn.datatables.net/colreorder/1.4.1/js/dataTables.colReorder.min.js"></script>
    {!! $dataTable->scripts() !!}
    <script type="text/javascript">
        $(document).ready(function() {
            var $dataTable = $('#dataTableBuilder');
            $dataTable.customButtons({
                buttons: [{
                    text: '<span class="fa fa-plus text-success"></span> <span class="text-success">Create</span>',
                    action: function (e) {
                        var $dialog = $('#note-add');
                        var $message = $('#message');
                        $dialog.modal('show', function () {
                            $message.focus();
                        });
                    }
                }]
            });

            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this note?',
                request: { method: 'GET', type: 'json' },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            $('#dataTableBuilder').DataTable().ajax.reload();
                        });
                }
            });
        });
    </script>
@endsection
