<form id="adjustment" class="form-horizontal" method="post" action="{{ route('admin.participant.transactions.store', $participant->getId()) }}">
    {{ csrf_field() }}
    <input type="hidden" name="id" value="{{ $transaction['id'] ?? '' }}" />
    <input type="hidden" name="user_id" value="{{ $transaction['user_id'] ?? $participant->getId() }}" />
    <input type="hidden" name="related_id" value="{{ $transaction['related_id'] ?? 0 }}" />
    <div class="form-group">
        <label for="transaction_date" class="col-sm-3 control-label required">Transaction Date:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control datepicker" id="transaction_date" name="transaction_date" value="{{ $transaction['transaction_date'] ?? date('m/d/Y') }}" />
        </div>
    </div>
    <div class="form-group">
        <label for="tax_date" class="col-sm-3 control-label required">Tax Date:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control datepicker" id="tax_date" name="tax_date" value="{{ $transaction['tax_date'] ?? date('m/d/Y') }}" />
        </div>
    </div>
    <div class="form-group">
        <label for="type" class="col-sm-3 control-label required">Adjustment Type:</label>
        <div class="col-sm-8">
            <select style="width: 100%" class="form-control select2" name="type" id="type" placeHolder="--- select ---" required>
                <option value="">--- select ---</option>
                @foreach($transactionTypes as $value => $text)
                    <option value="{{ $value }}" label="{{ $text }}" @if( $value == ( $transaction['type'] ?? '' )  )selected="selected"@endif>{{ $text }}</option>
                @endforeach
            </select>
        </div>
    </div>
    <div class="form-group">
        <label for="value" class="col-sm-3 control-label required">Value:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control" id="value" name="value" value="{{ $transaction['value'] ?? '' }}" />
        </div>
    </div>
    <div class="form-group">
        <label for="description" class="col-sm-3 control-label required">Description:</label>
        <div class="col-sm-8">
            <input type="text" class="form-control" id="description" name="description" rows="3" cols="75" value="{{ $transaction['description'] ?? '' }}">
        </div>
    </div>
    <div class="form-group">
        <label for="notes" class="col-sm-3 control-label required">Notes:</label>
        <div class="col-sm-8">
            <textarea class="form-control" id="notes" name="notes" rows="3" cols="75">{{ $transaction['notes'] ?? '' }}</textarea>
        </div>
    </div>
    <div class="form-group">
        <div class="col-sm-offset-3 col-sm-3">
            <a class="btn btn-default" href="{{ isset($cancelURI) ? url($cancelURI) : '#' }}" data-dismiss="modal">Cancel</a>
        </div>
        <div class="col-sm-5">
            <button type="submit" class="btn btn-primary pull-right" id="adjustSubmit">Submit</button>
        </div>
    </div>
</form>
