<section class="chart-line {{ $size }}">
    <div class="box box-primary" style="position: relative; overflow: hidden; height: 400px;">
        <div class="box-header">
            <i class="{{ $icon }}"></i>
            <h3 class="box-title">{{ $label }}</h3>
        </div>
        <div class="box-body border-radius-none">
        @if (empty($data))
            <div class="text-muted text-center">
                <span class="fa fa-exclamation-triangle fa-3x"></span>
                <h3>No data available</h3>
                <p>Try choosing a different date range</p>
            </div>
        @else
            <div class="chart" id="{{ $element }}" style="position: relative; height: 300px;"></div>
        @endif
        </div>
    </div>
</section>
@section('js')
    @parent
    <script type="text/javascript">
    new Morris.Line({
      element: '{{ $element }}',
      resize: true,
      data: {!! json_encode($data ?? []) !!},
      xkey: {!! json_encode($xkey) !!},
      ykeys: {!! json_encode($ykeys) !!},
      labels: {!! json_encode($labels) !!},
      lineColors: {!! json_encode($colors) !!},
      hideHover : 'auto',
      gridTextFamily   : 'Open Sans',
      gridTextSize     : 10
    });
    </script>
@endsection
