<?php

namespace Ignite\Core\Audit;

use OwenIt\Auditing\Contracts\Auditable;
use OwenIt\Auditing\Contracts\AuditDriver;
use OwenIt\Auditing\Drivers\Database;
use OwenIt\Auditing\Models\Audit;

class UserDriver extends Database implements AuditDriver
{
    /**
     * Perform an audit.
     *
     * @param \OwenIt\Auditing\Contracts\Auditable $model
     *
     * @return Audit
     */
    public function audit(Auditable $model)
    {
        $class = config('audit.implementation', Audit::class);

        $audit = $model->toAudit();

        return $class::create($audit);
    }
}
