@extends('Core::layouts.master')

@section('adminlte_css')
    <link rel="stylesheet" href="{{ asset('vendor/adminlte/dist/css/skins/skin-' . config('adminlte.skin', 'blue') . '.min.css')}} ">
    @stack('css')
    @yield('css')
@stop

@section('body_class', 'skin-' . config('adminlte.skin', 'blue') . ' sidebar-mini ' . (config('adminlte.layout') ? [
    'boxed' => 'layout-boxed',
    'fixed' => 'fixed',
    'top-nav' => 'layout-top-nav'
][config('adminlte.layout')] : '') . (config('adminlte.collapse_sidebar') ? ' sidebar-collapse ' : ''))

@section('body')
    <div class="wrapper">
        <header class="main-header">
            <a href="{{ url(config('adminlte.dashboard_url', 'home')) }}" class="logo">
                <span class="logo-mini">{!! config('adminlte.logo_mini', '<b>I</b>A') !!}</span>
                <span class="logo-lg">{!! config('adminlte.logo', '<b>Ignite</b>Admin') !!}</span>
            </a>
            <nav class="navbar navbar-static-top" role="navigation">
                <a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
                    <span class="sr-only">{{ trans('adminlte::adminlte.toggle_navigation') }}</span>
                </a>
                <div class="navbar-header">
                    <a href="{{ config('app.url') }}" class="navbar-brand">{{ config('app.name') }} &middot; <span class="fa fa-globe"></span></a>
                    <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse">
                        <i class="fa fa-bars"></i>
                    </button>
                </div>
                <div class="navbar-custom-menu">
                    <ul class="nav navbar-nav">
                        <li class="user user-menu">
                            <a onclick="confirm('This action will clear your browser preferences for this website. Do you want to continue?')" href="#" id="clear-local-storage">Clear preferences</a>
                        </li>
                        @php
                        $canAccessParticipantEdit = auth()->user()->can('core.user.edit', auth()->user());
                        $userProfile = $canAccessParticipantEdit
                            ? route('admin.participant.edit', auth()->user()->getKey())
                            : url('/participant/edit');
                        @endphp
                        <li class="user user-menu">
                            <a href="{{ $userProfile }}">
                                {{ auth()->user()->fullName() }}
                            </a>
                        </li>
                        @if (app('impersonation')->isImpersonating())
                        <li class="user user-menu">
                            <a href="{{ url('/admin/unmask') }}">
                                Unmask
                            </a>
                        </li>
                        @endif
                        <li>
                            @if(config('adminlte.logout_method') == 'GET' || !config('adminlte.logout_method') && version_compare(\Illuminate\Foundation\Application::VERSION, '5.3.0', '<'))
                                <a href="{{ url(config('adminlte.logout_url', 'auth/logout')) }}">
                                    <i class="fa fa-fw fa-power-off"></i> Logout
                                </a>
                            @else
                                <a href="#" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                    <i class="fa fa-fw fa-power-off"></i> Logout
                                </a>
                                <form id="logout-form" action="{{ url(config('adminlte.logout_url', 'auth/logout')) }}" method="POST" style="display: none;">
                                    @if(config('adminlte.logout_method'))
                                        {{ method_field(config('adminlte.logout_method')) }}
                                    @endif
                                    {{ csrf_field() }}
                                </form>
                            @endif
                        </li>
                        {{--<li>
                            <a href="#" data-toggle="control-sidebar"><i class="fa fa-gears"></i></a>
                        </li>--}}
                    </ul>
                </div>
            </nav>
        </header>

        <aside class="main-sidebar">
            <section class="sidebar">
                {{ $menu }}
            </section>
        </aside>

        <div class="content-wrapper">
            <section class="content-header">
                @yield('content_header')
            </section>
            <section class="content">
                @yield('content')
            </section>
        </div>
        <footer class="main-footer" style="overflow:hidden; position:relative;">
            <div class="text-left">
                <strong>&copy; {{ date('Y') }} All Rights Reserved.</strong>
            </div>
            <div class="brightspot" style="position:absolute; top:-100px; right:0;">
                <img src="/vendor/ignite/images/brightspot-logo.png" alt="Brightspot" class="img-responsive center-block">
            </div>
        </footer>

        {{-- @include('Core::partials.sidebar') --}}
    </div>
@stop

@section('adminlte_js')
    <script src="{{ asset('vendor/adminlte/dist/js/adminlte.min.js') }}"></script>
    @stack('js')
    @yield('js')
@stop
