<form id="page-editor" action="{{ $url }}" method="post">
    {{ csrf_field() }}
    {{ method_field($method) }}
    <div class="row form-affix-container">
        <div class="col-sm-9 form-affix-body">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    <li class="active"><a href="#form-content" data-toggle="tab">Content</a></li>
                </ul>
                <div class="tab-content form-horizontal">
                    <div class="tab-pane active" id="form-content">
                        <div class="form-group form-text">
                            <label for="form-content-title" class="col-sm-2 control-label">Name</label>
                            <div class="col-sm-10">
                                <div class="input-group">
                                    <input autocomplete="off" type="text" name="name" class="form-control" id="form-content-title" value="{{ old('name') ?? $block->getAttribute('name') }}" placeholder="Enter the block name">
                                    <span class="input-group-addon"><span class="fa fa-question"></span></span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group form-text">
                            <label for="form-content-code" class="col-sm-2 control-label">Code</label>
                            <div class="col-sm-10">
                                <div class="input-group text slug">
                                    <input autocomplete="off" name="code" type="text" class="form-control" id="form-content-code" value="{{ old('code') ?? $block->getAttribute('code') }}" placeholder="Enter the block code (e.g. sidebar.right.callout)">
                                    <span class="input-group-addon"><span class="fa fa-question"></span></span>
                                </div>
                            </div>
                        </div>
                        <div class="form-group form-editor">
                            <label for="form-content-content" class="col-sm-2 control-label">Content</label>
                            <div class="col-sm-10">
                                <textarea name="content" rows="20" class="form-control editor" id="form-content-content">{{ old('content') ?? $block->getAttribute('content') }}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-3 form-affix-actions form-affix-actions--affixed">
            <div class="box box-primary">
                <div class="box-body">
                    <div class="form-group select">
                        @php
                        $selectedStatus = old('status') ?? $block->getAttribute('status');
                        @endphp
                        <label for="form-content-status">Status</label>
                        <select class="form-control select2" name="status" id="form-content-status">
                            @foreach($block->getStatuses() as $value => $label)
                                <option value="{{ $value }}"{{ $value == $selectedStatus ? ' selected' : '' }}>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group form-date">
                        <label for="form-content-published_at">Publish Date</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <span class="fa fa-calendar"></span>
                            </div>
                            <input name="published_at" type="text" class="form-control datepicker" id="form-content-published_at" placeholder="e.g. {{ date('Y-m-d H:i:s') }}" value="{{ old('published_at') ? old('published_at') : $block->getAttribute('published_at') }}" />
                        </div>
                    </div>
                    {{--
                    <div class="form-group checkbox">
                        @php
                        $isProtected = old('is_protected') ?? $block->getAttribute('is_protected');
                        @endphp
                        <label class="checkbox-inline">
                            <input type="hidden" name="is_protected" value="0" />
                            <input type="checkbox" id="form-content-is-protected" name="is_protected" value="1"{{ $isProtected == '1' ? ' checked' : '' }} /> Protected Page?
                        </label>
                        <div id="form-content-allowed-groups" class="form-group checkboxes{{ $isProtected == '1' ? '' : ' hide' }}">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    Select the groups with access
                                </div>
                                <div class="panel-body no-padding" style="padding: 0 15px !important;">
                                    @include('Core::admin.cms.partials.form.groups', compact('page'))
                                </div>
                            </div>
                        </div>
                    </div>
                    --}}
                </div>
                <div class="box-footer">
                    <button type="submit" class="btn btn-primary pull-right">Save</button>
                    <a href="{{ route('admin.blocks.index') }}" class="btn btn-default pull-left">Cancel</a>
                </div>
            </div>
        </div>
    </div>
</form>