@extends('Core::layouts.cms')

@section('page_heading', 'Pages')
@section('page_breadcrumb', 'Pages')

@section('page_content')
<noscript>
    <div class="row">
        <div class="col-sm-12">
            <div class="nav-tabs-custom">
                <ul class="nav nav-tabs">
                    @can('core.cms.pages.browse')
                    <li class="active"><a href="{{ route('admin.pages.index') }}">Pages</a></li>
                    @endcan
                    @can('core.cms.blocks.browse')
                    <li><a href="{{ route('admin.blocks.index') }}">Blocks</a></li>
                    @endcan
                    @can('core.cms.pages.create')
                    <li class="nav-tabs-custom-toolbar pull-right">
                        <div class="box-tools">
                            <a class="btn btn-sm btn-primary" href="{{ route('admin.pages.create') }}">Create Page</a>&nbsp;&nbsp;
                        </div>
                    </li>
                    @endcan
                </ul>
                <div class="tab-content no-padding">
                    <ul class="nav nav-pills nav-stacked">
                        @forelse($pages as $page)
                            @include('Core::admin.cms.partials.list.item', compact('page'))
                        @empty
                            <li><a href="{{ route('admin.pages.create') }}">No pages created yet</a></li>
                        @endforelse
                    </ul>
                </div>
            </div>
        </div>
    </div>
</noscript>
<div id="cms-list">
    <cms-list :pages="{{ $pages }}"
              :can-browse="{{ auth()->user()->can('core.cms.pages.browse') ? 'true' : 'false' }}"
              :can-create="{{ auth()->user()->can('core.cms.pages.create') ? 'true' : 'false' }}"
              :can-update="{{ auth()->user()->can('core.cms.pages.update') ? 'true' : 'false' }}"
              :can-reorder="{{ auth()->user()->can('core.cms.pages.reorder') ? 'true' : 'false' }}"
              :can-toggle-status="{{ auth()->user()->can('core.cms.pages.status-toggle') ? 'true' : 'false' }}"
              :can-toggle-visibility="{{ auth()->user()->can('core.cms.pages.visibility-toggle') ? 'true' : 'false' }}"
              :can-browse-blocks="{{ auth()->user()->can('core.cms.blocks.browse') ? 'true' : 'false' }}"
    ></cms-list>
</div>
@endsection

@push('js')
    <script type="text/javascript">
        window.Translation = window.Translation || {};
        window.Translation.searchText = 'Search';
        window.Translation.createText = 'Create';
        window.Translation.tabPages = 'Pages';
        window.Translation.tabBlocks = 'Blocks';
        window.Translation.noRecords = 'No pages created yet.';
        window.Translation.viewPageFront = 'Click here to open the live version of the page.';
        window.Translation.visible = 'Click to hide the page in the navigation menu.';
        window.Translation.invisible = 'Click to show the page in the navigation menu.';
        window.Translation.active = 'The page is visible on the website. Click to deactivate the page.';
        window.Translation.inactive = 'The page is not visible on the website. Click to activate the page.';
        window.Translation.protected = 'The page is protected.';
        window.Pages = window.Pages || {};
        window.Pages.indexUrl = "{{ route('admin.pages.index') }}";
        window.Pages.createUrl = "{{ route('admin.pages.create') }}";
        window.Pages.editUrl = '/admin/cms/pages/edit';
        window.Pages.toggleUrl = '/admin/cms/pages/api/toggle';
        window.Pages.reorderUrl = '/admin/cms/pages/api/reorder';
        window.Blocks = window.Blocks || {};
        window.Blocks.indexUrl = '/admin/cms/blocks';
        window.Laravel = window.Laravel || {};
        window.Laravel.baseUrl = " {{ config('app.url') }}";
        window.Laravel.csrfToken = "{{ csrf_token() }}";
    </script>
    <script src="/vendor/ignite/js/cms/cms.js"></script>
@endpush