<?php

namespace Ignite\Core\Http\Controllers\Admin;

use Ignite\Core\Contracts\Repositories\ParticipantRepository;
use Illuminate\Http\Request;
use Ignite\Core\Models\Grid\InternalTable;
use Ignite\Core\Http\Controllers\Controller;

class InternalController extends Controller
{
    /**
     * @var ParticipantRepository
     */
    private $participantRepository;

    /**
     * TrashedController constructor.
     *
     * @param ParticipantRepository $participantRepository
     */
    public function __construct(ParticipantRepository $participantRepository)
    {
        $this->participantRepository = $participantRepository;
    }

    /**
     * The internal participants table.
     *
     * @param  string $status
     * @param  InternalTable $table
     * @param  Request $request
     * @return \Illuminate\Http\JsonResponse|\Illuminate\View\View
     */
    public function index($status = 'active', InternalTable $table, Request $request)
    {
        $status = $request->query('status', $status);
        $statuses = $this->participantRepository->getStatuses();
        $statusLookup = array_flip($statuses);

        if (! array_key_exists($status, $statusLookup)) {
            $status = 'active';
        }

        $current = $status;

        $table->with('status', $statusLookup[$status]);

        if ($request->wantsJson()) {
            return $table->ajax();
        }

        return $table->render('Core::admin.participants.internal.index', compact(
            'statuses',
            'current'
        ));
    }
}
