<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Ignite\Core\Entities\Note;
use Yajra\DataTables\DataTables;

class ParticipantNotesTable extends EloquentTable
{
    /**
     * The excluded column keys.
     * @var array
     */
    protected $excludedKeys = [];

    /**
     * The column keys that should be always visible.
     * @var array
     */
    protected $alwaysVisible = [];

    /**
     * @var ParticipantFormatter
     */
    protected $formatter;

    /**
     * ParticipantTable constructor.
     *
     * @param DataTables      $datatables
     * @param DatabaseManager $databaseManager
     * @param array           $params
     * @param NoteFormatter   $formatter
     */
    public function __construct(DataTables $datatables, DatabaseManager $databaseManager, array $params = [], NoteFormatter $formatter)
    {
        parent::__construct($datatables, $databaseManager, $params);

        $this->formatter = $formatter;
    }

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'created_at' => [
                'title' => 'Created',
                'name' => 'created_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'by_user_id' => [
                'title' => 'Added By',
                'name' => 'by_user_id',
                'orderable' => true,
                'exportable' => true,
            ],
            'message' => [
                'title' => 'Description',
                'name' => 'message',
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        return $this->applyScopes(
            Note::with('addedBy')->where('table_primary_id', $this->user_id)
        );
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        return [
            'by_user_id' => [$this->formatter, 'addedBy'],
            'message' => [$this->formatter, 'message'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        $params = parent::getBuilderParameters();

        return array_merge($params, [
            'order' => [[0, 'desc']],
            'buttons' => [
                'pageLength',
                $this->getColumnVisibilityButton(),
                'csv'
            ]
        ]);
    }
}
