<?php

namespace Ignite\Core\Helpers;

class Currency extends Amount
{
    /**
     * @var string
     */
    protected $currency;

    /**
     * Currency constructor.
     *
     * @param $value
     * @param string $currency
     */
    public function __construct($value, $currency = '$')
    {
        parent::__construct($value);
        $this->currency = $currency;
    }

    /**
     * Get the value formatted.
     *
     * @param  int $decimals
     * @param  int $default
     * @return string
     */
    public function format($decimals = 0, $default = 0)
    {
        $value = parent::format($decimals, $default);

        return $this->currency . $value;
    }
}
