<?php

namespace Ignite\Core\Contracts\Dashboard;

interface Chart
{
    /**
     * The HTML element ID.
     *
     * @return string
     */
    public function getElement();

    /**
     * The type of chart.
     *
     * @return mixed
     */
    public function getType();

    /**
     * The size element class.
     *
     * @return string
     */
    public function getSize();

    /**
     * The label of the chart.
     *
     * @return string
     */
    public function getLabel();

    /**
     * Get the correct data value from storage.
     *
     * @return mixed
     */
    public function getData();

    /**
     * Process the chart.
     *
     * @return array
     */
    public function process();
}
