<?php

namespace Ignite\Core\Models\Grid;

use Illuminate\Database\DatabaseManager;
use Yajra\DataTables\DataTables;

abstract class EloquentTable extends AbstractTable
{
    /** @var DatabaseManager */
    private $database;

    /**
     * TaxReport constructor.
     *
     * @param DataTables      $datatables
     * @param DatabaseManager $databaseManager
     * @param array           $params
     */
    public function __construct(
        DataTables $datatables,
        DatabaseManager $databaseManager,
        array $params = []
    ) {
        parent::__construct($datatables, $params);
        $this->database = $databaseManager;
    }

    /**
     * Get the database connection for a query engine report.
     *
     * @return \Illuminate\Database\Connection
     */
    protected function getConnection()
    {
        return $this->database->connection();
    }

    /**
     * Get the datatable instance.
     *
     * @return \Yajra\DataTables\DataTableAbstract
     */
    public function dataTable()
    {
        return $this->_dataTable($this->datatables->eloquent($this->query()));
    }
}
