<?php

namespace Ignite\Core\Contracts;

interface Importable
{
    /**
     * Assign the import data record for this import.
     *
     * @param  \Ignite\Core\Entities\Import $record
     * @return self
     */
    public function record(\Ignite\Core\Entities\Import $record);

    /**
     * Prepare any dependencies for each iteration of the import process.
     *
     * @return void
     */
    public function prepare();

    /**
     * The total number of records to be imported.
     *
     * @return int
     */
    public function count() : int;

    /**
     * Display the html for previewing the data.
     *
     * @return string
     */
    public function html() : string;

    /**
     * Attempt to map the correct fields from the provided headers.
     *
     * @return array
     */
    public function getHeaders() : array;

    /**
     * Preview a single line at the given offset.
     *
     * @param  int $offset
     * @return array
     */
    public function preview($offset = 1) : array;

    /**
     * Process the file and return the iterator.
     *
     * @return iterable
     */
    public function process() : iterable;

    /**
     * Validate a single line.
     *
     * @param  array $data
     * @return \Illuminate\Validation\Validator
     */
    public function validate(array $data) : \Illuminate\Validation\Validator;

    /**
     * Transform the data for a single line.
     *
     * @param  array $data
     * @return array
     */
    public function transform(array $data) : array;

    /**
     * Format an import message.

     * @param int   $line
     * @param array $data
     * @return string
     */
    public function formatImportMessage(int $line, array $data) : string;

    /**
     * Format a reject message.
     *
     * @param  int        $line
     * @param  array      $data
     * @param  \Exception $error
     * @return string
     */
    public function formatRejectMessage(int $line, array $data, \Exception $error) : string;

    /**
     * Process the data for a single line.
     *
     * @param  array $data
     * @return bool
     */
    public function save(array $data) : bool;
}
