<?php

namespace Ignite\Core\Models\Report;

use Ignite\Core\Entities\User;
use Ignite\Core\Http\Forms\ProfileForm;
use Ignite\Core\Models\Grid\ParticipantFormatter;
use Ignite\Core\Models\Grid\QueryTable;
use Ignite\Core\Traits\ReportFormConfiguration;

class EnrollmentReport extends QueryTable
{
    use ReportFormConfiguration;

    /**
     * The form to configure report columns when using ReportFormConfiguration trait.
     * @var string
     */
    protected $form = ProfileForm::class;

    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'user_id' => [
                'title' => 'User ID',
                'name' => 'participant.user_id',
                'orderable' => true,
                'exportable' => true,
            ],
            'created_at' => [
                'title' => 'Enrollment Date',
                'name' => 'participant.created_at',
                'orderable' => true,
                'exportable' => true,
            ],
            'first' => [
                'title' => 'First',
                'name' => 'participant.first',
                'orderable' => true,
                'exportable' => true,
            ],
            'last' => [
                'title' => 'Last',
                'name' => 'participant.last',
                'orderable' => true,
                'exportable' => true,
            ],
            'type' => [
                'title' => 'Type',
                'name' => 'participant.type',
                'orderable' => true,
                'exportable' => true,
            ],
            'email' => [
                'title' => 'E-mail',
                'name' => 'participant.email',
                'orderable' => true,
                'exportable' => true,
            ],
            'company' => [
                'title' => 'Company',
                'name' => 'participant.company',
                'orderable' => true,
                'exportable' => true,
            ],
            'address_1' => [
                'title' => 'Address 1',
                'name' => 'participant.address_1',
                'orderable' => true,
                'exportable' => true,
            ],
            'address_2' => [
                'title' => 'Address 2',
                'name' => 'participant.address_2',
                'orderable' => true,
                'exportable' => true,
            ],
            'city' => [
                'title' => 'City',
                'name' => 'participant.city',
                'orderable' => true,
                'exportable' => true,
            ],
            'state' => [
                'title' => 'State',
                'name' => 'participant.state',
                'orderable' => true,
                'exportable' => true,
            ],
            'postal' => [
                'title' => 'Postal',
                'name' => 'participant.postal',
                'orderable' => true,
                'exportable' => true,
            ],
            'phone1' => [
                'title' => 'Phone',
                'name' => 'participant.phone1',
                'orderable' => true,
                'exportable' => true,
            ],
            // Invisible columns
            'employee_id' => [
                'title' => 'Employee ID',
                'name' => 'participant.employee_id',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'title' => [
                'title' => 'Title',
                'name' => 'participant.title',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'phone2' => [
                'title' => 'Phone 2',
                'name' => 'participant.phone2',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'phone3' => [
                'title' => 'Phone 3',
                'name' => 'participant.phone3',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'department_1' => [
                'title' => 'Department 1',
                'name' => 'participant.department_1',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'department_2' => [
                'title' => 'Department 2',
                'name' => 'participant.department_2',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'work_address_1' => [
                'title' => 'Work Address 1',
                'name' => 'participant.work_address_1',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'work_address_2' => [
                'title' => 'Work Address 2',
                'name' => 'participant.work_address_2',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'work_city' => [
                'title' => 'Work City',
                'name' => 'participant.work_city',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'work_state' => [
                'title' => 'Work State',
                'name' => 'participant.work_state',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'work_postal' => [
                'title' => 'Work Postal',
                'name' => 'participant.work_postal',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'work_country' => [
                'title' => 'Work Country',
                'name' => 'participant.work_country',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'alternate_email' => [
                'title' => 'Alternate Email',
                'name' => 'participant.alternate_email',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'region' => [
                'title' => 'Region',
                'name' => 'participant.region',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
            'dob' => [
                'title' => 'Date of Birth',
                'name' => 'participant.dob',
                'visible' => false,
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())->keyBy('name')->keys()->toArray();

        return $this->applyScopes(
            $this->getConnection()->table('core_participant as participant')
                ->select($columns)
                ->distinct()
                ->leftJoin('core_user as user', 'user.user_id', '=', 'participant.user_id')
                ->where('user.internal', User::TYPE_PARTICIPANT)
                ->where('user.status', User::STAT_ACTIVE)
        );
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        $formatter = app(ParticipantFormatter::class);
        return [
            'agree_confirm_1' => [$formatter, 'agreeConfirm1'],
            'agree_confirm_2' => [$formatter, 'agreeConfirm2'],
            'archived' => [$formatter, 'archived'],
            'internal' => [$formatter, 'internal'],
            'status' => [$formatter, 'status'],
        ];
    }
}
