<?php

namespace Ignite\Core\Models\Grid;

use Ignite\Core\Entities\Group;

class GroupTable extends EloquentTable
{
    /**
     * The columns to show.
     *
     * @return array
     */
    public function columns()
    {
        return [
            'checkbox' => [
                'defaultContent' => '',
                'title'          => '',
                'data'           => 'checkbox',
                'name'           => 'checkbox',
                'orderable'      => false,
                'searchable'     => false,
                'exportable'     => false,
                'printable'      => false,
                'width'          => '10px',
            ],
            'action' => [
                'name' => 'actions',
                'title' => 'Actions',
                'searchable' => false,
                'orderable' => false,
                'exportable' => false,
                'printable' => false,
                'visible' => true,
                'width' => '80px',
                'class' => 'actions'
            ],
            'id' => [
                'title' => 'Group ID',
                'name' => 'id',
                'orderable' => true,
                'exportable' => true,
            ],
            'key' => [
                'title' => 'Key',
                'name' => 'key',
                'orderable' => true,
                'exportable' => true,
            ],
            'name' => [
                'title' => 'Name',
                'name' => 'name',
                'orderable' => true,
                'exportable' => true,
            ],
            'description' => [
                'title' => 'Description',
                'name' => 'description',
                'orderable' => true,
                'exportable' => true,
            ],
            'level' => [
                'title' => 'Level',
                'name' => 'level',
                'orderable' => true,
                'exportable' => true,
            ],
            'status' => [
                'title' => 'Status',
                'name' => 'status',
                'orderable' => true,
                'exportable' => true,
            ],
            'is_user_defined' => [
                'title' => 'User Defined',
                'name' => 'is_user_defined',
                'orderable' => true,
                'exportable' => true,
            ],
        ];
    }

    /**
     * The report query.
     *
     * @return \Illuminate\Database\Query\Builder
     */
    public function query()
    {
        $columns = collect($this->getColumns())->keyBy('name')->except(['checkbox', 'actions'])->keys()->toArray();

        return $this->applyScopes(
            Group::query()
        );
    }

    /**
     * Get a map of column keys => functions to format columns.
     *
     * @return array
     */
    protected function getColumnFormattingMap()
    {
        $formatter = app(GroupFormatter::class);
        return [
            'checkbox' => [$formatter, 'checkbox'],
            'action' => [$formatter, 'actions'],
            'status' => [$formatter, 'status'],
            'is_user_defined' => [$formatter, 'isUserDefined'],
        ];
    }

    /**
     * Get default builder parameters.
     *
     * @return array
     */
    protected function getBuilderParameters()
    {
        $params = parent::getBuilderParameters();

        return array_merge($params, [
            'order' => [[6, 'asc']],
            'select' => [
                'info' => true,
                'style' => 'multi',
                'selector' => 'td:first-child'
            ],
            'columnDefs' => [
                ['targets' => 0, 'checkboxes' => ['selectRow' => true]]
            ],
            'ajax' => ['type' => 'POST'],
            'buttons' => [
                'pageLength',
                $this->getColumnVisibilityButton(),
                'postCsv'
            ],
        ]);
    }
}
