<?php

namespace Ignite\Core;

use Illuminate\Foundation\Application;

final class Program
{
    const TYPE_PAYOUT = 'payout';
    const TYPE_REDEMPTION = 'redemption';

    /**
     * @var Application
     */
    private $application;

    /**
     * Program constructor.
     *
     * @param Application $application
     */
    public function __construct(Application $application)
    {
        $this->application = $application;
    }

    /**
     * The type of program.
     *
     * @return string
     */
    public function getType()
    {
        return $this->application['config']
                    ->get('core.program_type', static::TYPE_REDEMPTION);
    }

    /**
     * Determine if this is a payout program.
     *
     * @return bool
     */
    public function isPayout()
    {
        return $this->getType() == self::TYPE_PAYOUT;
    }

    /**
     * Determine if this is a redemption program.
     *
     * @return bool
     */
    public function isRedemption()
    {
        return $this->getType() == self::TYPE_REDEMPTION;
    }
}
