<?php

namespace Ignite\Core\Helpers;

use Carbon\Carbon;

class Date
{
    /**
     * @var Carbon|string|int
     */
    private $value;

    /**
     * DateTime constructor.
     *
     * @param Carbon|string|int $value
     */
    public function __construct($value)
    {
        $this->value = $value;
    }

    /**
     * Reformat a Date with a default value
     *
     * @param  string $format
     * @param  string $default
     * @return false|string
     */
    public function format($format = 'm/d/Y', $default = '')
    {
        $date = $this->value;

        if (empty(trim($date))) {
            return $default;
        }

        try {
            $date = Carbon::parse('Y-m-d', $date);
        } catch (\Exception $e) {
            return $default;
        }

        return $date->format($format);
    }
}
