<?php

namespace Ignite\Core\Providers;

use Illuminate\Support\ServiceProvider;
use Ignite\Core\Console\Data\Encrypt;
use Ignite\Core\Console\ThemeScaffold;
use Ignite\Core\Console\Import;

class ConsoleServiceProvider extends ServiceProvider
{
    protected $defer = false;

    /**
     * The available commands
     *
     * @var array
     */
    protected $commands = [
        //ThemeScaffold::class,
        Import::class,
        Encrypt::class,
    ];

    /**
     * Register the commands.
     */
    public function register()
    {
        $this->commands($this->commands);
    }

    /**
     * The classes the provider provides.
     *
     * @return array
     */
    public function provides()
    {
        $provides = $this->commands;

        return $provides;
    }
}
