@extends('Core::layouts.import')

@section('page_heading', 'Overview')
@section('page_breadcrumb', 'Overview')

@section('page_content')
    <div class="row">
        @can('core.import.create')
        <div class="col-md-4">
            @include('Core::admin.import.partials.form')
        </div>
        @endcan
        @can('core.import.browse')
        @include('Core::admin.import.partials.table')
        @endcan
    </div>
@endsection

@section('js')
    @parent
    @can('core.import.delete')
    <script type="text/javascript">
        $(document).ready(function() {
            $.deleteEntry({
                confirmation: 'Are you sure you want to delete this import',
                request: { method: 'DELETE', type: 'json' },
                data: {
                    _token: "{{ csrf_token() }}"
                },
                onSuccess: function(button) {
                    button.closest('tr')
                        .animate({'backgroundColor': this.settings.background})
                        .fadeOut(function() {
                            $(this).remove();
                            var table = $('#recent-imports');
                            if (table.find('table > tbody > tr').length === 0) {
                                table.remove();
                            }
                        });
                }
            });
        });
    </script>
    @endcan
@endsection
